﻿using System;
using System.Collections.Generic;

public partial class AutoReferralTriage : BasePage 
{
    private const string REFERRER_KEY = "AutoReferralTriage_Referrer";

    private static IReadOnlyList<string> _navigationSources = new List<string>
    {
        "/AdminListUsers.aspx",
        "/AdminEditUsersRoles.aspx",
        "/AdminListReferenceRanges.aspx",
        "/AdminDoDFragment.aspx",
        "/PatientWorkflows.aspx"
    };

    public AutoReferralTriage()
    {
        NavigationSources = _navigationSources;
    }

    protected void Page_Load(object sender, EventArgs e)
    {
        if (!IsPostBack)
        {
            SetReferringPage();
        }
    }

    protected void CloseButton_OnClick(object sender, EventArgs e)
    {
        RedirectToReferringPage();
    }

    public override string TopMenuName()
    {
        return "Administration";
    }

    public override string MenuItemName()
    {
        return "EFR AUTO TRIAGE";
    }

    public override string AppObjectCode()
    {
        return "EFR AUTO TRIAGE";
    }
}
